/*
//###########################################################################
//
// FILE:    F28069_RAM_lnk.cmd
//
//###########################################################################
*/

MEMORY
{
PAGE 0 :    /* program space */
   /* BEGIN is used for the "boot to SARAM" bootloader mode   */

   BEGIN       : origin = 0x000000, length = 0x000002
   RAML0       : origin = 0x008000, length = 0x00B800	 /* RAML0-8 combined for size of .text */
   RESET       : origin = 0x3FFFC0, length = 0x000002

   BOOTROM     : origin = 0x3FF3B0, length = 0x000C10


PAGE 1 :    /* data space */

   BOOT_RSVD   : origin = 0x000002, length = 0x00004E     /* Part of M0, BOOT rom will use this for stack */
   RAMM0       : origin = 0x000050, length = 0x0007B0      /* on-chip RAM block M0M1 */
   USB_RAM     : origin = 0x040000, length = 0x000800     /* USB RAM		  */

   FPUTABLES   : origin = 0x3FD590, length = 0x0006A0	 /* FPU Tables in Boot ROM */
   IQTABLES    : origin = 0x3FDC30, length = 0x000B50    /* IQ Math Tables in Boot ROM */
   IQTABLES2   : origin = 0x3FE780, length = 0x00008C    /* IQ Math Tables in Boot ROM */
   IQTABLES3   : origin = 0x3FE80C, length = 0x0000AA	 /* IQ Math Tables in Boot ROM */
}


SECTIONS
{
   /* Setup for "boot to SARAM" mode:
      The codestart section (found in DSP28_CodeStartBranch.asm)
      re-directs execution to the start of user code.  */
   codestart        : > BEGIN,      PAGE = 0
   .text            : > RAML0,      PAGE = 0	
   copysections     : > RAML0,      PAGE = 0
   .cinit           : > RAML0,      PAGE = 0
   .pinit           : > RAML0,      PAGE = 0
   .switch          : > RAML0,      PAGE = 0
   .reset           : > RESET,      PAGE = 0, TYPE = DSECT /* not used, */

   .stack           : > RAMM0,      PAGE = 1
   .ebss            : > RAML0,      PAGE = 0
   .econst          : > RAML0,      PAGE = 0
   .esysmem         : > RAML0,      PAGE = 0

   IQmath           : > RAML0,      PAGE = 0
   IQmathTables     : > IQTABLES,   PAGE = 1, TYPE = NOLOAD
   
   /* Allocate FPU math areas: */
   FPUmathTables    : > FPUTABLES,  PAGE = 1, TYPE = NOLOAD
   
  /* Uncomment the section below if calling the IQNexp() or IQexp()
      functions from the IQMath.lib library in order to utilize the
      relevant IQ Math table in Boot ROM (This saves space and Boot ROM
      is 1 wait-state). If this section is not uncommented, IQmathTables2
      will be loaded into other memory (SARAM, Flash, etc.) and will take
      up space, but 0 wait-state is possible.
   */
/*  IQmathTables2    : > IQTABLES2, PAGE = 1, TYPE = NOLOAD
   {
              IQmath.lib<IQNexpTable.obj> (IQmathTablesRam)
   }*/
   /* Uncomment the section below if calling the IQNasin() or IQasin()
      functions from the IQMath.lib library in order to utilize the
      relevant IQ Math table in Boot ROM (This saves space and Boot ROM
      is 1 wait-state). If this section is not uncommented, IQmathTables2
      will be loaded into other memory (SARAM, Flash, etc.) and will take
      up space, but 0 wait-state is possible.
   */
/*  IQmathTables3    : > IQTABLES3, PAGE = 1, TYPE = NOLOAD
    {
               IQmath.lib<IQNasinTable.obj> (IQmathTablesRam)
    }*/

}

/*
//===========================================================================
// End of file.
//===========================================================================
*/
